package net.sf.javaprinciples.presentation.view;

import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Encapsulates the build and layout of UI widgets
 *
 * @author Warwick Slade
 */
public interface View
{
    public void add(View view);
    public void remove(View view);

    public Widget getWidget();

    public void reportError(String message);
    public void clearError();

    public void setEnabled(boolean enabled);

    public void addValueChangedListener(ValueChangeListener listener);
    public void removeValueChangedListener(ValueChangeListener listener);

}
