package net.sf.javaprinciples.presentation.view;

import java.util.HashMap;
import java.util.Map;

import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.view.model.ConfirmationViewFactory;
import net.sf.javaprinciples.presentation.view.model.MemoViewFactory;
import net.sf.javaprinciples.presentation.view.model.PropertyViewFactory;

/**
 * Build a delegating ViewFactory
 *
 * @author Warwick Slade
 */
public class ViewFactoryBuilder
{
    enum Type
    {
        PROPERTY,
        CONFIRMATION,
        MEMO
    }

    public ViewFactory build(ClientContext clientContext)
    {
        Map<Type, ViewFactory> viewFactories = defineViewFactories(clientContext);

        ViewFactoryImpl viewFactory = new ViewFactoryImpl(viewFactories);

        return viewFactory;
    }

    protected Map<Type, ViewFactory> defineViewFactories(ClientContext clientContext)
    {
        Map<Type, ViewFactory> factories = new HashMap<Type, ViewFactory>();

        factories.put(Type.PROPERTY, new PropertyViewFactory(clientContext.getWidgetFactory()));
        factories.put(Type.CONFIRMATION, new ConfirmationViewFactory(clientContext.getWidgetFactory()));
        factories.put(Type.MEMO, new MemoViewFactory(clientContext.getWidgetFactory()));

        return factories;
    }
}
