package net.sf.javaprinciples.presentation.view;

import java.util.Map;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;

/**
 * Determine which ViewFactory to create
 *
 * @author Warwick Slade
 */
public class ViewFactoryImpl implements ViewFactory
{
    Map<ViewFactoryBuilder.Type, ViewFactory> viewFactories;

    public ViewFactoryImpl(Map<ViewFactoryBuilder.Type, ViewFactory> viewFactories)
    {
        this.viewFactories = viewFactories;
    }

    @Override
    public View createView(AttributeMetadata attributeMetadata, String content)
    {
        String controlFactory = attributeMetadata.getControlFactory();
        ViewFactoryBuilder.Type viewFactoryName;

        if (StringUtilsShared.isBlank(controlFactory))
        {
            viewFactoryName = ViewFactoryBuilder.Type.PROPERTY;
        }
        else
        {
            viewFactoryName = ViewFactoryBuilder.Type.valueOf(controlFactory.toUpperCase());
        }

        return viewFactories.get(viewFactoryName).createView(attributeMetadata, content);
    }
}
