package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;

/**
 * A view that will contain multiple widgets.
 *
 * A header is placed at the top of the view.
 *
 * @author Warwick Slade
 */
public class CompositeView implements View
{
    ComplexPanel rootPanel;
    FlowPanel contentPanel;
    HTML errorLabel;

    public CompositeView(String viewName)
    {
        rootPanel = contentPanel = new FlowPanel();
        contentPanel.setStyleName(viewName);

        errorLabel = makeErrorLabel();
        contentPanel.add(errorLabel);
    }

    public CompositeView(ClientContext clientContext, AttributeMetadata attributeMetadata)
    {
        this(clientContext, attributeMetadata, null);
    }

    public CompositeView(ClientContext clientContext, AttributeMetadata attributeMetadata, String viewName)
    {
        contentPanel = new FlowPanel();

        errorLabel = makeErrorLabel();
        contentPanel.add(errorLabel);

        if (viewName != null)
        {
            contentPanel.setStyleName(viewName);
        }

        String label = attributeMetadata.getLabel();
        if (!StringUtilsShared.isBlank(label))
        {
            rootPanel = new FlowPanel();
            Label header = new HTML(label);
            header.setStyleName("propertySheetHeader");
            rootPanel.add(header);
            rootPanel.add(contentPanel);
        }
        else
        {
            rootPanel = contentPanel;
        }

        ViewExtension extension = clientContext.getModelSupport().findExtension(attributeMetadata.getExtensions(), ViewExtension.class);

        String description = null;
        if (extension != null)
        {
            description = extension.getDescription();

            if (StringUtilsShared.isBlank(description))
            {
                description = attributeMetadata.getDescription();
            }
        }

        if (!StringUtilsShared.isBlank(description))
        {
            Label header = new HTML(description);
            header.setStyleName("propertySheetDescription");
            contentPanel.add(header);
        }
    }

    private HTML makeErrorLabel()
    {
        HTML errorLabel = new HTML();
        errorLabel.setVisible(false);
        errorLabel.setStyleName("propertySheetHeaderError");
        return errorLabel;
    }

    @Override
    public void add(View view)
    {
        contentPanel.add(view.getWidget());
    }

    @Override
    public void remove(View view)
    {
        contentPanel.remove(view.getWidget());
    }

    @Override
    public Widget getWidget()
    {
        return rootPanel;
    }

    @Override
    public void addValueChangedListener(ValueChangeListener listener)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void removeValueChangedListener(ValueChangeListener listener)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void reportError(String message)
    {
        errorLabel.setHTML(message);
        errorLabel.setVisible(true);
    }

    public void clearError()
    {
        errorLabel.setVisible(false);
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        // Nothing required
    }
}
