package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;

import net.sf.javaprinciples.graph.GraphWriter;
import net.sf.javaprinciples.graph.json.JsonGraphWriter;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.control.ControlContainer;
import net.sf.javaprinciples.presentation.control.model.ClassControl;
import net.sf.javaprinciples.presentation.view.View;

public class FormView extends ModelView
{
    View view;
    String name;
    ComplexPanel contentPanel;

    public FormView(ClientContext clientContext)
    {
        this(clientContext, ViewType.FORM.value());
    }

    protected FormView(ClientContext clientContext, String name)
    {
        super(clientContext);

        this.name = name;

        contentPanel = new FlowPanel();
        contentPanel.setStyleName("middleBox");
        add(contentPanel);

        setStyleName("dock");
    }

    public void layout()
    {
        if (view != null)
        {
            contentPanel.remove(view.getWidget());
        }

        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);
        String disabledDescription = null;
        if (extension.isDisabled())
        {
            disabledDescription = extension.getDescription();
            if (StringUtilsShared.isBlank(disabledDescription))
            {
                disabledDescription = "This feature will be available in a future version.";
            }
            extension.setDescription(null);
        }
        view = new CompositeView(name);

        if (disabledDescription != null)
        {
            view.reportError(disabledDescription);
        }

        ControlContainer container = new ClassControl(model, view, clientContext);
        container.bind(content);

        contentPanel.add(view.getWidget());

        injectButton(container);
    }

    protected void injectButton(final ControlContainer container)
    {
        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);

        if (extension.isDisabled())
        {
            // Add
            container.setEnabled(false);
            return;
        }

        if (extension.isReadOnly())
        {
            container.setEnabled(false);

            if (StringUtilsShared.isBlank(extension.getAction()))
            {
                // No button
                return;
            }
        }

        String action = extension.getAction();
        if (StringUtilsShared.isBlank(action))
        {
            action = model.getLabel();
        }
        Button submit = new Button(action);
        submit.setStyleName("btn btn-default");
        submit.addClickHandler(new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                handleSubmit(container);
            }
        });
        ((ComplexPanel) view.getWidget()).add(submit);
    }

    protected GraphWriter unbind(ControlContainer container)
    {
        GraphWriter writer = new JsonGraphWriter();
        writer.writeObject("");
        container.unbind(writer);
        writer.writeObject();

        return writer;
    }

    protected void handleSubmit(ControlContainer container)
    {
        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);

        GraphWriter writer = unbind(container);

        if (writer.hasErrors())
        {
            // Display the Form error message
            view.reportError("Your form cannot be submitted until you correct the errors below.");
            Window.scrollTo(0, 0);
            return;
        }
        else
        {
            view.clearError();
        }

        String identifier = determineTargetProcess(0);

        clientContext.storeContent(identifier, writer.toString(), new ClientContext.StoreContentAsynchCall()
        {
            @Override
            public void storeSuccess(String identifier, String detail)
            {
                switch (determineSubmitAction())
                {
                    case BACK:
                        clientContext.raiseStatusMessage(detail);
                        clientContext.gotoPlace(null);
                        break;
                    case DISPLAY:
                        contentPanel.remove(view.getWidget());
                        HTML html = new HTML(detail);
                        html.setStyleName("propertySheetMemo");
                        contentPanel.add(html);
                        break;
                }
            }

            @Override
            public void storeFail(String identifier, String reason)
            {
                clientContext.raiseStatusMessage(reason, true);
                Window.scrollTo(0, 0);
            }
        });
    }
}