package net.sf.javaprinciples.presentation.view.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;

/**
 * TODO
 *
 * @author Warwick Slade
 */
public abstract class LeafView implements View, ValueChangeListener
{
    private Widget container;
    private List<ValueChangeListener> listeners = new ArrayList<ValueChangeListener>();

    public Widget getContainer()
    {
        return container;
    }

    public void setContainer(Widget container)
    {
        this.container = container;
    }

    @Override
    public void add(View view)
    {
        throw new RuntimeException("Can not add a view to a property view");
    }

    @Override
    public void remove(View view)
    {
        throw new RuntimeException("Can not remove a view from a property view");
    }

    @Override
    public Widget getWidget()
    {
        return container;
    }

    @Override
    public void addValueChangedListener(ValueChangeListener listener)
    {
        listeners.add(listener);
    }

    @Override
    public void removeValueChangedListener(ValueChangeListener listener)
    {
        listeners.remove(listener);
    }

    @Override
    public void valueChanged(String value)
    {
        for (ValueChangeListener listener : listeners)
        {
            listener.valueChanged(value);
        }
    }

    @Override
    public void reportError(String message)
    {
    }

    @Override
    public void clearError()
    {
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        // Nothing required
    }
}
