package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;

import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.model.ModelPlace;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;

/**
 * Handle the submission
 *
 * @author Warwick Slade
 */
public class ListView extends ModelView
{
    View view;
    String name;
    ComplexPanel contentPanel;

    public ListView(ClientContext clientContext)
    {
        super(clientContext);

        contentPanel = new FlowPanel();
        contentPanel.setStyleName("middleBox");
        add(contentPanel);

        setStyleName("dock");
    }

    public void layout()
    {
        if (view != null)
        {
            contentPanel.remove(view.getWidget());
        }

        String content = StringUtilsShared.removeInstanceName(this.content.toString());
        content = StringUtilsShared.removeInstanceName(content);

        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);
        String disabledDescription = null;

        if (extension != null && extension.isDisabled())
        {
            disabledDescription = extension.getDescription();
            if (StringUtilsShared.isBlank(disabledDescription))
            {
                disabledDescription = "This feature will be available in a future version.";
            }
            extension.setDescription(null);
        }

        view = new CompositeView(clientContext, model);

        if (disabledDescription != null)
        {
            view.reportError(disabledDescription);
        }

        View listView  = new ListViewFactory2(clientContext.getWidgetFactory(), clientContext.getModelSupport(), clientContext).createView(model , content);
        view.add(listView);

        contentPanel.add(view.getWidget());
        listView.addValueChangedListener(new ValueChangeListener()
        {
            @Override
            public void valueChanged(String objectIdentifier)
            {
                String processIdentifier = determineTargetProcess(0);

                Place place = new ModelPlace(determineTargetView(0), processIdentifier, objectIdentifier);
                clientContext.gotoPlace(place);
            }
        });

        injectButton();
    }

    protected void injectButton()
    {
        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);

        if (extension.isReadOnly())
        {
            // No button
            return;
        }

        String action = extension.getAction();
        if (StringUtilsShared.isBlank(action))
        {
            // No button
            return;
        }
        Button submit = new Button(action);
        submit.addClickHandler(new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                handleSubmit();
            }
        });
        ((ComplexPanel)view.getWidget()).add(submit);
    }

    private void handleSubmit()
    {
        clientContext.storeContent(determineTargetProcess(1), "{na:{}}", new ClientContext.StoreContentAsynchCall()
        {
            @Override
            public void storeSuccess(String identifier, String detail)
            {
                switch (determineSubmitAction())
                {
                    case BACK:
                        clientContext.raiseStatusMessage(detail);
                        clientContext.gotoPlace(null);
                        break;
                    case DISPLAY:
                        contentPanel.remove(view.getWidget());
                        HTML html = new HTML(detail);
                        html.setStyleName("propertySheetMemo");
                        contentPanel.add(html);
                        break;
                }
            }

            @Override
            public void storeFail(String identifier, String reason)
            {
                clientContext.raiseStatusMessage(reason, true);
                Window.scrollTo(0, 0);
            }
        });
    }
}