package net.sf.javaprinciples.presentation.view.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gwt.dom.client.Style;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadataExtension;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;

/**
 * TODO
 *
 * @author Warwick Slade
 */
public class ListViewFactory implements ViewFactory
{
    private ModelSupport modelSupport;

    public ListViewFactory(ModelSupport modelSupport)
    {
        this.modelSupport = modelSupport;
    }

    @Override
    public View createView(AttributeMetadata attributeMetadata, String content)
    {
        TableView listView = new TableView();

        DataGrid widget = new DataGrid<JSONObject>();
        widget.setWidth("100%");
        widget.setAutoHeaderRefreshDisabled(true);

        // Do we need this?
        widget.setHeight("300");

        List<AttributeMetadata> classAttributeMetadatas = obtainListAttributes(attributeMetadata);
        for (AttributeMetadata classAttributeMetadata : classAttributeMetadatas)
        {
            final AttributeMetadata classAttributeMetadataf = classAttributeMetadata;
            TextColumn column = new TextColumn<JSONObject>()
            {
                @Override
                public String getValue(JSONObject object)
                {
                    JSONValue value = object.get(classAttributeMetadataf.getName());
                    return value.toString();
                }
            };
            widget.addColumn(column, classAttributeMetadata.getLabel());

            // Do we need this??
            widget.setColumnWidth(column, 40, Style.Unit.PX);
        }

        JSONObject value = (JSONObject)JSONParser.parseStrict(content);

        JSONArray array = (JSONArray)value.get("result");

        List<JSONObject> list = new ArrayList<JSONObject>(array.size());
        for (int i = 0; i < array.size(); i++)
        {
            list.add((JSONObject)array.get(i));
        }

        widget.setRowCount(list.size());
        widget.setRowData(list);


        SimpleLayoutPanel container = new SimpleLayoutPanel();
        container.add(widget);

        listView.setContainer(container);

        return listView;
    }

    private List<AttributeMetadata> obtainListAttributes(AttributeMetadata attributeMetadata)
    {
        // From the process object we need the class
        ClassMetadataExtension extension = modelSupport.findExtension(attributeMetadata.getExtensions(), ClassMetadataExtension.class);
        ClassMetadata classMetadata = extension.getClazz();

        // Now get the search object from the process
        List<AttributeMetadata> classAttributeMetadatas = classMetadata.getAttributes();
        AttributeMetadata result = classAttributeMetadatas.get(0);


        ClassMetadataExtension resultAttributes = modelSupport.findExtension(result.getExtensions(), ClassMetadataExtension.class);

        return resultAttributes.getClazz().getAttributes();
    }
}
