package net.sf.javaprinciples.presentation.view.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.BusinessObjectMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadataExtension;
import net.sf.javaprinciples.model.metadata.EnumerationExtension;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.model.ModelPlace;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.widget.WidgetFactory;

/**
 * TODO
 *
 * @author Warwick Slade
 */
public class ListViewFactory2 implements ViewFactory
{
    private ModelSupport modelSupport;
    private WidgetFactory widgetFactory;
    private ClientContext clientContext;

    public ListViewFactory2(WidgetFactory widgetFactory, ModelSupport modelSupport, ClientContext clientContext)
    {
        this.modelSupport = modelSupport;
        this.widgetFactory = widgetFactory;
        this.clientContext = clientContext;
    }

    @Override
    public View createView(AttributeMetadata attributeMetadata, String content)
    {
        FlowPanel panel = new FlowPanel();

        Widget selectWidget = makeSelector(attributeMetadata);
        if (selectWidget != null)
        {
            panel.add(selectWidget);
        }

        final TableView listView = new TableView();

        List<AttributeMetadata> classAttributeMetadatas = obtainListAttributes(attributeMetadata);
        classAttributeMetadatas = filterListAttributes(classAttributeMetadatas);

        final JSONArray array = (JSONArray)JSONParser.parseStrict(content);

        final HTMLTable table = new Grid(array.size(), classAttributeMetadatas.size());
        table.setCellSpacing(0);
        table.setStyleName("search_results_table");

        table.addClickHandler(new ClickHandler()
        {
            public void onClick(ClickEvent event)
            {
                HTMLTable.Cell cell = table.getCellForEvent(event);
                if (cell == null)
                {
                    return;
                }
                int row = cell.getRowIndex();
                JSONValue idValue = ((JSONObject) array.get(row)).get("id");
                if (idValue != null)
                {
                    String id = idValue.isString().stringValue();
                    listView.valueChanged(id);
                }
            }
        });

        addHeader(table.getElement(), classAttributeMetadatas);

        for (int row = 0; row < array.size(); row++)
        {
            int col = 0;
            for (AttributeMetadata classAttributeMetadata : classAttributeMetadatas)
            {
                JSONValue jvalue = ((JSONObject)array.get(row)).get(classAttributeMetadata.getName());
                if (jvalue !=  null)
                {
                    String svalue = jvalue.isString().stringValue();
                    Widget w = readOnlyValue(classAttributeMetadata, svalue);
                    table.setWidget(row, col, w);
                }
                col++;
            }
        }

        panel.add(table);
        listView.setContainer(panel);

        return listView;
    }

    private Widget makeSelector(AttributeMetadata attributeMetadata)
    {
        AttributeMetadata selector = obtainSelector(attributeMetadata);
        if (selector == null)
        {
            return null;
        }

        EnumerationExtension enumExtension = modelSupport.findExtension(selector.getExtensions(), EnumerationExtension.class);
        List<BusinessObjectMetadata> items = enumExtension.getListItems();
        if (items.size() == 1)
        {
            return null;
        }

        final ModelPlace currentPlace = determineCurrentPlace();
        String selectedItem = currentPlace != null ? currentPlace.getContent() : null;
        if ("all".equals(selectedItem))
        {
            selectedItem = enumExtension.getListItems().get(0).getName();
        }

        // The listener should not be implemented in the factory
        Widget selectWidget = widgetFactory.createWidget(selector, new ValueChangeListener()
            {
                @Override
                public void valueChanged(String value)
                {
                    if (currentPlace != null)
                    {
                        ModelPlace newPlace = new ModelPlace(currentPlace.getUseCase(), currentPlace.getModel(), value);
                        clientContext.gotoPlace(newPlace);
                    }
                }
            }, selectedItem);
        return selectWidget;
    }

    private ModelPlace determineCurrentPlace()
    {
        String token = History.getToken();
        String[] parts = token.split(":");
        if (parts.length != 2)
        {
            // This is unexpected - how best to handle?
            return null;
        }
        return new ModelPlace.Tokenizer().getPlace(parts[1]);
    }

    private Widget readOnlyValue(AttributeMetadata classAttributeMetadata, String svalue)
    {
        // Should we cache the current value, or use another mechanism to "render a value"
        classAttributeMetadata.setReadOnly(true);
        return widgetFactory.createWidget(classAttributeMetadata, null, svalue);
    }

    private void addHeader(Element table, List<AttributeMetadata> classAttributeMetadatas)
    {
        // use DOM to create thead element....
        Element thead = DOM.createElement("thead");
        Element tr = DOM.createTR();

        // add columns
        DOM.appendChild(thead,tr);
        for (AttributeMetadata classAttributeMetadata : classAttributeMetadatas)
        {
            Element th = DOM.createTH();
            DOM.appendChild(tr,th);
            // add some text to the header...
            DOM.setInnerText(th, classAttributeMetadata.getLabel());
        }

        // get the table element
        // and add the thead before the tbody
        DOM.insertChild(table,thead,0);
    }

    private List<AttributeMetadata> filterListAttributes(List<AttributeMetadata> attributeMetadataList)
    {
        List<AttributeMetadata> filterList = new ArrayList<AttributeMetadata>();
        for (AttributeMetadata attributeMetadata : attributeMetadataList)
        {
            if (attributeMetadata.isHidden())
            {
                continue;
            }
            filterList.add(attributeMetadata);
        }
        return filterList;
    }

    private List<AttributeMetadata> obtainListAttributes(AttributeMetadata attributeMetadata)
    {
        // From the process object we need the class
        ClassMetadataExtension extension = modelSupport.findExtension(attributeMetadata.getExtensions(), ClassMetadataExtension.class);
        ClassMetadata classMetadata = extension.getClazz();

        // Now get the search object from the process
        List<AttributeMetadata> classAttributeMetadatas = classMetadata.getAttributes();

        AttributeMetadata result = classAttributeMetadatas.get(classAttributeMetadatas.size() - 1);

        ClassMetadataExtension resultAttributes = modelSupport.findExtension(result.getExtensions(), ClassMetadataExtension.class);

        return resultAttributes.getClazz().getAttributes();
    }

    private AttributeMetadata obtainSelector(AttributeMetadata attributeMetadata)
    {
        // From the process object we need the class
        ClassMetadataExtension extension = modelSupport.findExtension(attributeMetadata.getExtensions(), ClassMetadataExtension.class);
        ClassMetadata classMetadata = extension.getClazz();

        // Now get the search object from the process
        List<AttributeMetadata> classAttributeMetadatas = classMetadata.getAttributes();

        if (classAttributeMetadatas.size() == 1)
        {
            return null;
        }
        return classAttributeMetadatas.get(0);
    }
}
