package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.widget.WidgetFactory;

/**
 * Displays only label that is as wide as possible.
 *
 * @author Warwick Slade
 */
public class MemoViewFactory implements ViewFactory
{
    public MemoViewFactory(WidgetFactory widgetFactory)
    {
    }


    @Override
    public View createView(AttributeMetadata attributeMetadata, String content)
    {
        LeafView view = new LeafView()
        {

        };

        // 2. Create a label
        Widget label = makeLabel(content);
        view.setContainer(label);

        if (attributeMetadata.isHidden())
        {
            label.setVisible(false);
        }

        return view;
    }

    protected Widget makeLabel(String content)
    {
        Label label = new HTML(content);
        label.setStyleName("propertySheetMemo");
        return label;
    }
}
