package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;

/**
 * Layout a menu item from the metadata
 *
 * @author Warwick Slade
 */
public class MenuItemViewFactory implements ViewFactory
{
    @Override
    public View createView(final AttributeMetadata attributeMetadata, String content)
    {
        final MenuItemView view = new MenuItemView();

        FlowPanel container = new FlowPanel();
        container.setStyleName("menu_item_container");
        view.setContainer(container);

        FlowPanel menuItem = new FlowPanel();
        menuItem.setStyleName("menu_item");
        container.add(menuItem);

        ClickHandler clickHandler = new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                view.valueChanged(attributeMetadata.getName());
            }
        };

        Anchor icon = new Anchor();
        Image image = new Image();
        image.setStyleName("menu_item_icon");
        image.setStyleName("menu_item_icon-" + attributeMetadata.getName(), true);
        icon.getElement().appendChild(image.getElement());
        icon.setStyleName("pull-left");
        icon.addClickHandler(clickHandler);
        menuItem.add(icon);

        String labelText = attributeMetadata.getLabel();
        FlowPanel labelContainer = new FlowPanel();
        labelContainer.setStyleName("menu_item_body");
        Anchor label = new Anchor(labelText);
        label.setStyleName("menu_item_label");
        label.addClickHandler(clickHandler);
        labelContainer.add(label);
        menuItem.add(labelContainer);

        String descriptionText = attributeMetadata.getDescription();
        FlowPanel descriptionContainer = new FlowPanel();
        descriptionContainer.setStyleName("menu_item_description");
        Anchor description = new Anchor(descriptionText);
        description.setStyleName("");
        description.addClickHandler(clickHandler);
        descriptionContainer.add(description);
        menuItem.add(descriptionContainer);

        return view;
    }
}
