package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.Extension;
import net.sf.javaprinciples.model.metadata.IdentifierExtension;
import net.sf.javaprinciples.model.metadata.InstanceExtension;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.model.ModelPlace;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;

import java.util.List;

/**
 * Create
 */
public class MenuView extends ModelView
{
    ComplexPanel center;
    private ViewFactory menuItemViewFactory = new MenuItemViewFactory();

    public MenuView(ClientContext clientContext)
    {
        super(clientContext);
    }

    public void layout()
    {
        if (center != null)
        {
            remove(center);
        }

        center = new FlowPanel();
        center.setStyleName("menu_middle_column");
        add(center);

        Label header = new Label(model.getLabel());
        header.setStyleName("menu_header");
        center.add(header);

        renderMenuGroup();
    }

    private FlowPanel createMenuPanel()
    {
        FlowPanel menuPanel = new FlowPanel();
        menuPanel.setStyleName("row");
        FlowPanel menuSubPanel = new FlowPanel();
        menuSubPanel.setStyleName("menu_panel");
        menuPanel.add(menuSubPanel);
        return menuPanel;
    }

    private void renderMenuGroup()
    {
        InstanceExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), InstanceExtension.class);
        if (extension != null)
        {
            for (AttributeMetadata instance : extension.getInstances())
            {
                FlowPanel menuPanel = createMenuPanel();
                center.add(menuPanel);
                Panel menu = (FlowPanel)menuPanel.getWidget(0);
                Panel menuGroup = createMenuGroupItem(instance);
                renderMenuItems(menuGroup, instance);
                menu.add(menuGroup);
            }
        }
    }

    private Panel createMenuGroupItem(AttributeMetadata instance)
    {
        Label header = new Label(instance.getLabel());
        header.setStyleName("menu_group_heading");
        FlowPanel menuGroup = new FlowPanel();
        menuGroup.setStyleName("menu_group");
        menuGroup.add(header);
        return menuGroup;
    }

    private void renderMenuItems(Panel menuGroup, AttributeMetadata menuGroupInstance)
    {
        InstanceExtension extension = clientContext.getModelSupport()
                .findExtension(menuGroupInstance.getExtensions(), InstanceExtension.class);

        if (extension != null)
        {
            for (AttributeMetadata instance : extension.getInstances())
            {
                View menuItemView = menuItemViewFactory.createView(instance, null);
                addListener(menuItemView, instance);
                menuGroup.add(menuItemView.getWidget());
            }
        }
    }

    private void addListener(View menuItemView, final AttributeMetadata instance)
    {
        menuItemView.addValueChangedListener(new ValueChangeListener()
        {
            @Override
            public void valueChanged(String value)
            {
                List<Extension> extensionList = instance.getExtensions();
                ViewExtension viewExtension = clientContext.getModelSupport().findExtension(extensionList, ViewExtension.class);
                if (viewExtension == null)
                {
                    throw new RuntimeException("View was not set - cant determine view type : Update the model");
                }
                String viewName = viewExtension.getType().value();
                if (StringUtilsShared.isBlank(viewName))
                {
                    throw new RuntimeException("The view type was not set : Update the model");
                }
                String optionalContent = viewExtension.getContent();
                IdentifierExtension identifierExtension = clientContext.getModelSupport().findExtension(extensionList, IdentifierExtension.class);
                clientContext.gotoPlace(new ModelPlace(viewName, identifierExtension.getIdentifier(), optionalContent));
            }
        });
    }
}