package net.sf.javaprinciples.presentation.view.model;

import java.util.List;

import com.google.gwt.user.client.ui.DockPanel;

import com.google.gwt.user.client.ui.FlowPanel;
import net.sf.javaprinciples.graph.GraphReader;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.IdentifierExtension;
import net.sf.javaprinciples.model.metadata.InstanceExtension;
import net.sf.javaprinciples.model.metadata.SubmitAction;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.presentation.activity.ClientContext;

public abstract class ModelView extends FlowPanel
{
    ClientContext clientContext;
    AttributeMetadata model;
    GraphReader content;

    public ModelView(ClientContext clientContext)
	{
		this.clientContext = clientContext;
	}

	public abstract void layout();

    public void setContent(GraphReader content)
    {
        this.content = content;
    }

    public void setModel(AttributeMetadata model)
    {
        this.model = model;
    }

    protected String determineTargetProcess(int index)
    {
        InstanceExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), InstanceExtension.class);

        if (extension != null)
        {
            List<AttributeMetadata> associatedObjects = extension.getInstances();

            if (!associatedObjects.isEmpty())
            {
                AttributeMetadata searchResultObject = associatedObjects.get(index);
                IdentifierExtension identifierExtension = clientContext.getModelSupport().findExtension(searchResultObject.getExtensions(), IdentifierExtension.class);
                return identifierExtension.getIdentifier();
            }
        }

        IdentifierExtension identifierExtension = clientContext.getModelSupport().findExtension(model.getExtensions(), IdentifierExtension.class);
        if (identifierExtension != null)
        {
            return identifierExtension.getIdentifier();
        }
        return null;
    }

    protected String determineTargetView(int index)
    {
        InstanceExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), InstanceExtension.class);

        if (extension == null)
        {
            return ViewType.FORM.value();
        }

        List<AttributeMetadata> associatedObjects = extension.getInstances();

        if (associatedObjects.isEmpty())
        {
            return ViewType.FORM.value();
        }
        AttributeMetadata searchResultObject = associatedObjects.get(index);
        ViewExtension viewExtension = clientContext.getModelSupport().findExtension(searchResultObject.getExtensions(), ViewExtension.class);
        return viewExtension.getType().value();
    }

    protected SubmitAction determineSubmitAction()
    {
        ViewExtension viewExtension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);
        return viewExtension.getSubmitAction();
    }
}