package net.sf.javaprinciples.presentation.view.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * TODO
 *
 * @author Warwick Slade
 */
public class MultipleInstanceView implements View
{
    private final static String[] indexLabels = {"First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth"};

    private TabPanel tabPanel;
    private List<InstanceView> instanceViews = new ArrayList<InstanceView>();
    private AttributeMetadata attributeMetadata;
    private boolean repeating;

    public MultipleInstanceView(AttributeMetadata attributeMetadata, boolean repeating)
    {
        this.attributeMetadata = attributeMetadata;
        tabPanel = new TabPanel();
        this.repeating = repeating;
    }

    @Override
    public void add(View view)
    {
        int index = tabPanel.getWidgetCount();
        InstanceView instanceView = new InstanceView(Integer.toString(index));

        tabPanel.add(view.getWidget(), instanceView.makeTab(tabLabel(index)));

        if (index == 0)
        {
            tabPanel.selectTab(0);
        }
    }

    @Override
    public void remove(View view)
    {
        tabPanel.remove(view.getWidget());
    }

    @Override
    public Widget getWidget()
    {
        return tabPanel;
    }

    @Override
    public void reportError(String message)
    {
        //ToDo
    }

    @Override
    public void clearError()
    {
        //ToDo
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        for (InstanceView view : instanceViews)
        {
            view.setEnabled(enabled);
        }
    }

    @Override
    public void addValueChangedListener(ValueChangeListener listener)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void removeValueChangedListener(ValueChangeListener listener)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    protected String tabLabel(int index)
    {
        String baseLabel = label();
        if (!repeating)
        {
            return baseLabel;
        }
        return indexLabels[index] + " " + baseLabel;
    }

    protected String label()
    {
        String label = attributeMetadata.getLabel();
        if (label != null)
        {
            return label;
        }
        return attributeMetadata.getName();
    }

    public class InstanceView
    {
        private Widget exclamation;
        private Label tabLabel;
        private String identifier;

        public InstanceView(String identifier)
        {
            this.identifier = identifier;
        }

        protected Widget makeTab(String tabMsg)
        {
            ComplexPanel tab = new FlowPanel();
            tab.setStylePrimaryName("tabIcon");
            tabLabel = new Label(tabMsg);
            tabLabel.setStyleName("inlineLabel", true);
            tab.add(tabLabel);
            exclamation = new FlowPanel();
            exclamation.setStylePrimaryName("exclamation");
            exclamation.setVisible(false);
            tab.add(exclamation);

            DOM.setElementAttribute(tab.getElement(), "id", identifier + "-tab");

            return tab;
        }

        public void setEnabled(boolean enabled)
        {
        }
    }
}
