package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 *
 * @author Warwick Slade
 */
public class PropertyView extends LeafView
{
    private Label errorMessage;
    private Widget label;
    private Widget input;

    public Widget getLabel()
    {
        return label;
    }

    public void setLabel(Widget label)
    {
        this.label = label;
    }

    public Widget getInput()
    {
        return input;
    }

    public void setInput(Widget input)
    {
        this.input = input;
    }

    public void reportError(String message)
    {
        errorMessage.setText(message);
        errorMessage.setVisible(true);

        getContainer().addStyleName("propertySheetContainerError");
    }

    public void clearError()
    {
        errorMessage.setVisible(false);
        getContainer().removeStyleName("propertySheetContainerError");
    }

    public void setErrorMessage(Label errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        ((HasEnabled)input).setEnabled(enabled);
    }
}
