package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.view.gwt.widget.SimpleDomElementWrappingWidget;
import net.sf.javaprinciples.presentation.widget.WidgetFactory;

import static com.google.gwt.user.client.DOM.*;

/**
 * Builds the widgets for an attribute
 *
 * @author Warwick Slade
 */
public class PropertyViewFactory implements ViewFactory
{
    private WidgetFactory widgetFactory;

    public PropertyViewFactory(WidgetFactory widgetFactory)
    {
        this.widgetFactory = widgetFactory;
    }

    @Override
    public View createView(AttributeMetadata attributeMetadata, String content)
    {
        PropertyView view = new PropertyView();

        // 1. Create a holder
        ComplexPanel container = makeContainer();
        view.setContainer(container);

        // 2. Create an error reporting label
        Label errorLabel = makeErrorLabel(attributeMetadata);
        view.setErrorMessage(errorLabel);
        container.add(errorLabel);

        // 2. Create a label
        Widget label = makeLabel(attributeMetadata);
        view.setLabel(label);
        container.add(label);

        // 3. Create an input
        Widget input = makeInput(attributeMetadata, view, content);
        view.setInput(input);
        container.add(input);

        // 4. Create a tooltip

        if (attributeMetadata.isHidden())
        {
            container.setVisible(false);
        }

        return view;
    }

    protected Widget makeInput(AttributeMetadata attributeMetadata, PropertyView view, String content)
    {
        final Widget input = widgetFactory.createWidget(attributeMetadata, view, content);

        input.setStyleName("propertySheetInput");
        if (!attributeMetadata.isOptional() && !attributeMetadata.isReadOnly())
        {
            if (StringUtilsShared.isBlank(content))
            {
                input.setStyleName("propertySheetRequired", true);
            }
            view.addValueChangedListener(new ValueChangeListener()
            {
                @Override
                public void valueChanged(String value)
                {
                    input.setStyleName("propertySheetRequired", StringUtilsShared.isBlank(value));
                }
            });
        }

        return input;
    }

    protected Widget makeInput(AttributeMetadata attributeMetadata, PropertyView view, String content, String prefix)
    {
        final Widget input = makeInput(attributeMetadata, view, content);

        if (input instanceof TextBox && prefix != null)
        {
            TextBox tb = (TextBox)input;
            String prefixedName = prefix + attributeMetadata.getName();
            tb.setName(prefixedName);
            tb.getElement().setId(prefixedName);
        }

        return input;
    }

    protected Label makeErrorLabel(AttributeMetadata attributeMetadata)
    {
        Label label = new HTML(attributeMetadata.getLabel());
        label.setStyleName("propertySheetErrorLabel");
        label.setVisible(false);
        return label;
    }

    protected Widget makeLabel(AttributeMetadata attributeMetadata)
    {
        return makeLabel(attributeMetadata.getLabel(), attributeMetadata.getName());
    }

    protected Widget makeLabel(String labelText, String labelFor)
    {
        LabelElement label = Document.get().createLabelElement();
        label.setInnerText(labelText);
        label.setClassName("propertySheetLabel");
        label.setHtmlFor(labelFor);

        return new SimpleDomElementWrappingWidget(label);
    }

    protected ComplexPanel makeContainer()
    {
        FlowPanel container = new FlowPanel();
        container.setStyleName("propertySheetContainer");
        return container;
    }
}
