package net.sf.javaprinciples.presentation.view.model;

import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.model.ModelPlace;

/**
 * Handle the submission
 *
 * @author Warwick Slade
 */
public class RedirectView extends FormView
{
    public RedirectView(ClientContext clientContext)
    {
        super(clientContext, ViewType.FORM.value());
    }

    public void layout()
    {
        if (view != null)
        {
            contentPanel.remove(view.getWidget());
        }
        view = new CompositeView(name);

        content.readObject(model.getName());

        // Redirect
        String model = content.readString("initialModel");
        ModelPlace nextPlace = new ModelPlace(ViewType.MENU.value(), model);
        clientContext.gotoPlace(nextPlace);
    }
}