package net.sf.javaprinciples.presentation.view.model;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ComplexPanel;

import net.sf.javaprinciples.graph.GraphWriter;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.IdentifierExtension;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.MessageBox;
import net.sf.javaprinciples.presentation.activity.model.ModelPlace;
import net.sf.javaprinciples.presentation.control.ControlContainer;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.view.View;

/**
 * Handle the submission
 *
 * @author Warwick Slade
 */
public class SearchView extends FormView
{
    AttributeMetadata searchModel;
    String searchContent;
    View searchResultView;

    public SearchView(ClientContext clientContext)
    {
        super(clientContext, ViewType.SEARCH.value());
    }

    protected void injectButton(final ControlContainer container)
    {
        ViewExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), ViewExtension.class);
        String action = extension.getAction();
        if (StringUtilsShared.isBlank(action))
        {
            action = model.getLabel();
        }
        Button submit = new Button(action);
        submit.setStyleName("btn btn-default");
        submit.addClickHandler(new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                handleSubmit(container);
            }
        });

        // For search we want the button to be at the end of the input fields
        // If we got the css correct for the panel holding the attributes it would not be necessary
        // to try and find the panel.
        ComplexPanel p1 = (ComplexPanel)view.getWidget();

        ComplexPanel p2 = (ComplexPanel)p1.getWidget(1);
        ComplexPanel p3 = (ComplexPanel)p2.getWidget(1);
        ComplexPanel p4 = (ComplexPanel)p3.getWidget(2);
        p4.add(submit);
    }

    protected void handleSubmit(ControlContainer container)
    {
        GraphWriter writer = unbind(container);

        // Reset
        searchModel = null;
        searchContent = null;

        loadSearchResultModel();
        loadSearchResult(writer);
    }

    private void readyToLayout()
    {
        if (searchContent == null || searchModel == null)
        {
            return;
        }
        searchLayout();
    }

    private void searchLayout()
    {
        if (searchResultView != null)
        {
            view.remove(searchResultView);
        }

        String searchContent = StringUtilsShared.removeInstanceName(this.searchContent.toString());
        searchContent = StringUtilsShared.removeInstanceName(searchContent);

        if ("{}".equals(searchContent))
        {
            view.reportError("No members found, please search again.");
        }
        else
        {
            searchResultView  = new ListViewFactory2(clientContext.getWidgetFactory(), clientContext.getModelSupport(), clientContext).createView(searchModel, searchContent);

            searchResultView.addValueChangedListener(new ValueChangeListener()
            {
                @Override
                public void valueChanged(String objectIdentifier)
                {
                    String processIdentifier = determineTargetProcess(1);
                    String viewType = determineTargetView(1);
                    Place place = new ModelPlace(viewType, processIdentifier, objectIdentifier);
                    clientContext.gotoPlace(place);
                }
            });

            view.add(searchResultView);
        }
    }

    private void loadSearchResult(GraphWriter writer)
    {
        // Find the identifier of this attribute
        IdentifierExtension extension = clientContext.getModelSupport().findExtension(model.getExtensions(), IdentifierExtension.class);
        //String searchResultIdentifier = determineTargetProcess(0);

        view.clearError();

        clientContext.retrieveContent(extension.getIdentifier(), writer.toString(), new ClientContext.RetrieveContentAsynchCall()
        {
            @Override
            public void contentReady(String identifier, String content)
            {
                searchContent = content;
                readyToLayout();
            }

            @Override
            public void contentFail(String identifier, String reason)
            {
                MessageBox.dialogBox("Search Failed", reason);
            }
        });
    }

    private void loadSearchResultModel()
    {
        // Find the search result association
        String searchResultIdentifier = determineTargetProcess(0);
        clientContext.loadModel(searchResultIdentifier, new ClientContext.ModelAsynchCall()
        {
            @Override
            public void modelReady(String identilfier, AttributeMetadata model)
            {
                searchModel = model;
                readyToLayout();
            }

            @Override
            public void modelFail(String identifier, String reason)
            {
                // TODO
            }
        });
    }
}