package net.sf.javaprinciples.presentation.widget;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Create a label for rendering an Address
 * Does not support editing as the address fields are handled by a composite.
 *
 * @author Warwick Slade
 */
public class AddressWidgetFactory implements WidgetFactory
{
    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               final ValueChangeListener listener,
                               String content)
    {
        if (!metadata.isReadOnly())
        {
            throw new RuntimeException("Address Widget can not render an editable widget");
        }

        StringBuilder builder = new StringBuilder();

        if (!StringUtilsShared.isBlank(content))
        {
            String[] parts = content.split(",");
            String lineOne = parts[0].replaceAll("\\s", "&nbsp;");
            builder.append(lineOne);
            if (parts.length > 1)
            {
                builder.append("<br>");
                for (int i = 1 ; i < parts.length; i++)
                {
                    if (i != 1)
                    {
                        builder.append(", ");
                    }
                    String part = parts[i].replaceAll("\\s", "&nbsp;");
                    builder.append(part);
                }
            }
        }
        return new HTML(builder.toString());
    }
}
