package net.sf.javaprinciples.presentation.widget;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Create a widget based on a Date Input
 *
 * @author Warwick Slade
 */
public class BooleanWidgetFactory implements WidgetFactory
{
    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               final ValueChangeListener listener,
                               String content)
    {
        if (metadata.isReadOnly())
        {
            return new Label(content != null ? content : "");
        }

        CheckBox input = new CheckBox();
        input.setName(metadata.getName());
        String title = metadata.getLabel();
        if (title != null)
        {
            input.setTitle(title);
        }

        if (!StringUtilsShared.isBlank(content))
        {
            input.setValue(Boolean.parseBoolean(content));
        }

        input.addValueChangeHandler(new ValueChangeHandler<Boolean>()
        {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event)
            {
                Boolean value = event.getValue();
                String svalue = value != null ? value.toString() : "false";
                listener.valueChanged(svalue);
            }
        });
        return input;
    }
}
