package net.sf.javaprinciples.presentation.widget;

import java.util.Date;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Create a widget based on a Date Input
 *
 * @author Warwick Slade
 */
public class DateWidgetFactory implements WidgetFactory
{
    private static final DateTimeFormat presentationFormat = DateTimeFormat.getFormat(StringUtilsShared.DATE_FORMAT_PRESENTATION);
    private static final DateTimeFormat internalFormat = DateTimeFormat.getFormat(StringUtilsShared.DATE_FORMAT_INTERNAL);

    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               final ValueChangeListener listener,
                               String content)
    {
        if (metadata.isReadOnly())
        {
            if (!StringUtilsShared.isBlank(content))
            {
                content = presentationFormat.format(internalFormat.parse(content));
            }
            return new Label(content != null ? content : "");
        }

        DateBox input = new DateBox();
        input.setFormat(new DateBox.DefaultFormat(presentationFormat));
        //input.setName(metadata.getName());
        String title = metadata.getLabel();
        if (title != null)
        {
            input.setTitle(title);
        }

        if (!StringUtilsShared.isBlank(content))
        {
            input.setValue(internalFormat.parse(content));
        }

        input.addValueChangeHandler(new ValueChangeHandler<Date>()
        {
            @Override
            public void onValueChange(ValueChangeEvent<Date> event)
            {
                Date value = event.getValue();
                String svalue = value != null ? internalFormat.format(value) : null;
                listener.valueChanged(svalue);
            }
        });
        return input;
    }
}
