package net.sf.javaprinciples.presentation.widget;

import java.util.List;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.BusinessObjectMetadata;
import net.sf.javaprinciples.model.metadata.EnumerationExtension;
import net.sf.javaprinciples.model.metadata.ListAttributeExtension;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Create a widget based on a Text Input
 *
 * @author W
 */
public class ListWidgetFactory implements WidgetFactory
{
    private ModelSupport modelSupport;

    public ListWidgetFactory(ModelSupport modelSupport)
    {
        this.modelSupport = modelSupport;
    }

    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               final ValueChangeListener listener,
                               String content)
    {
        final ListBox input = new ListBox();
        input.setName(metadata.getName());

        // Sorts out the required selection
        if (!metadata.isOptional())
        {
        	ListAttributeExtension listExtension = modelSupport.findExtension(metadata.getExtensions(), ListAttributeExtension.class);
        	
            if(listExtension != null)
            {
                String requiredSelection = listExtension.getRequiredSelection();
                if (requiredSelection != null)
                {
                    input.addItem(requiredSelection, "");
                }
        	}
        }

        // Sorts out the elements of the list
        if ("Enumeration".equals(metadata.getType()))
        {	
        	EnumerationExtension enumExtension = modelSupport.findExtension(metadata.getExtensions(), EnumerationExtension.class);
            
            if (enumExtension != null)
            {

                List<BusinessObjectMetadata> items = enumExtension.getListItems();
                int index = input.getItemCount();

                for (BusinessObjectMetadata item : items)
                {
                    String label = item.getLabel();
                    String name = item.getName();

                    if (label == null)
                    {
                        input.addItem(name);
                    }
                    else
                    {
                        input.addItem(label, name);
                    }
                    if (content != null && content.equals(name))
                    {
                        input.setSelectedIndex(index);
                    }
                    index++;
                }
            }
        }

        String title = metadata.getDescription();
        if (title != null)
        {
            input.setTitle(title);
        }

        input.addChangeHandler(new ChangeHandler()
        {
            @Override
            public void onChange(ChangeEvent event)
            {
                int index = input.getSelectedIndex();
                String value = index != -1 ? input.getValue(index) : null;
                listener.valueChanged(value);
            }
        });
        return input;
    }
}
