package net.sf.javaprinciples.presentation.widget;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.TextAttributeExtension;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;
import net.sf.javaprinciples.presentation.filter.CharacterFilter;
import net.sf.javaprinciples.presentation.filter.EmailAddressFilter;
import net.sf.javaprinciples.presentation.filter.NumberFilter;
import net.sf.javaprinciples.presentation.filter.PhoneNumberFilter;
import net.sf.javaprinciples.presentation.filter.TextFilter;

/**
 * Create a widget based on a Text Input
 *
 * @author W
 */
public class TextWidgetFactory implements WidgetFactory
{
    private ModelSupport modelSupport;

    public TextWidgetFactory(ModelSupport modelSupport)
    {
        this.modelSupport = modelSupport;
    }

    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               final ValueChangeListener listener,
                               String content)
    {
        if (metadata.isReadOnly())
        {
            return new Label(content != null ? content : "");
        }

        TextAttributeExtension extension = modelSupport.findExtension(metadata.getExtensions(), TextAttributeExtension.class);
        String type = metadata.getType();

        TextBox input;

        if ("password".equals(metadata.getControlName()))
        {
            input = new PasswordTextBox();
        }
        else
        {
            input = new TextBox();
        }

        input.setName(metadata.getName());
        input.getElement().setId(metadata.getName());
        input.setText(content);

        int ilength = -1;
        int isize = -1;

        String controlType = metadata.getControlName();
        if (controlType != null)
        {
            type = controlType;
        }

        CharacterFilter cfilter = null;
        if (type.equals("number"))
        {
            cfilter = new NumberFilter();
        }
        else if (type.equals("phoneNumber"))
        {
            cfilter = new PhoneNumberFilter();
            isize = 12;
            ilength = 12;
        }
        else if (type.equals("emailAddress"))
        {
            cfilter = new EmailAddressFilter();
            isize = 30;
            ilength = 255;
        }

        if (cfilter != null)
        {
            input.addKeyDownHandler(new TextFilter(input, cfilter));
        }

        if (extension != null)
        {
            int length = extension.getLength();
            if (length != 0)
            {
                ilength = length;
            }
            int size = extension.getSize();
            if (size != 0)
            {
                isize = size;
            }
        }

        if (ilength != -1)
        {
            input.setMaxLength(ilength);
        }
        if (isize != -1)
        {
            input.setVisibleLength(isize);
        }

        String title = metadata.getDescription();
        if (title != null)
        {
            input.setTitle(title);
        }

        if (content == null)
        {
            content = metadata.getDefaultValue();
        }

        if (content != null && content.length() > 0)
        {
           input.setText(content);
        }

        input.addValueChangeHandler(new ValueChangeHandler<String>()
        {
            @Override
            public void onValueChange(ValueChangeEvent<String> event)
            {
                String value = event.getValue();
                listener.valueChanged(value);
            }
        });
        return input;
    }
}
