package net.sf.javaprinciples.presentation.widget;

import java.util.HashMap;
import java.util.Map;

import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.activity.ClientContext;

/**
 * Build a widget factory with an set of widget factories for different types;
 *
 * @author Warwick Slade
 */
public class WidgetFactoryBuilder
{
    public WidgetFactory build(ClientContext clientContext)
    {
        Map<String, WidgetFactory> factories = defineFactories(clientContext);

        return new WidgetFactoryImpl(factories);
    }

    protected Map<String, WidgetFactory> defineFactories(ClientContext clientContext)
    {
        ModelSupport modelSupport = clientContext.getModelSupport();

        Map<String, WidgetFactory> factories = new HashMap<String, WidgetFactory>();
        TextWidgetFactory textWidgetFactory = new TextWidgetFactory(modelSupport);
        factories.put("number", textWidgetFactory);
        factories.put("int", textWidgetFactory);
        factories.put("phoneNumber", textWidgetFactory);
        factories.put("emailAddress", textWidgetFactory);
        factories.put("password", textWidgetFactory);

        factories.put("address", new AddressWidgetFactory());

        factories.put("String", textWidgetFactory);
        factories.put("text.simple", textWidgetFactory);

        factories.put("Enumeration", new ListWidgetFactory(modelSupport));
        factories.put("Date", new DateWidgetFactory());
        factories.put("dateOfBirth", new DateOfBirthWidgetFactory());
        factories.put("boolean", new BooleanWidgetFactory());

        return factories;
    }
}
