package net.sf.javaprinciples.presentation.widget;

import java.util.Map;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.control.ValueChangeListener;

/**
 * Create an input widget based the metadata type.
 *
 * @author Warwick Slade
 */
public class WidgetFactoryImpl implements WidgetFactory
{
    private Map<String, WidgetFactory> widgetsFactory;

    public WidgetFactoryImpl(Map<String, WidgetFactory> widgetsFactory)
    {
        this.widgetsFactory = widgetsFactory;
    }

    @Override
    public Widget createWidget(AttributeMetadata metadata,
                               ValueChangeListener listener,
                               String content)
    {
        String type = metadata.getControlName();
        if (StringUtilsShared.isBlank(type))
        {
            type = metadata.getType();
        }

        WidgetFactory widgetFactory = widgetsFactory.get(type);
        if (widgetFactory != null)
        {
            Widget widget = widgetFactory.createWidget(metadata, listener, content);

            // Do we still need this
            //DOM.setElementAttribute(widget.getElement(), "id", metadata.getName() + "-widget");

            return widget;

        }
        return new Label("Invalid type:" + type);

    }
}
