/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.data.transformer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiffResult
implements Serializable {
    private boolean different;
    private Map<String, Difference> fields = new HashMap<String, Difference>();

    public DiffResult(String field, Difference difference) {
        this.fields.put(field, difference);
        this.different = difference != Difference.SAME && difference != Difference.BOTH_NULL;
    }

    public boolean isDifferent() {
        return this.different;
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public Difference getDifference(String field) {
        return this.fields.get(field);
    }

    public String toString() {
        return this.isDifferent() ? "Different" : "Same";
    }

    public void add(DiffResult e) {
        this.fields.putAll(e.fields);
        if (!this.different) {
            this.different = e.isDifferent();
        }
    }

    public static enum Difference {
        BOTH_NULL,
        LEFT_NULL,
        RIGHT_NULL,
        SAME,
        DIFFERENT;

    }
}

