/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.data.transformer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ValidationResult
implements Serializable {
    public static final String REQUIRED = "it is missing and is a required attribute";
    private static final String FORMAT = "The field %s failed validation because %s.";
    private Map<String, String> fields = new HashMap<String, String>();

    public ValidationResult() {
    }

    public ValidationResult(String field, String reason) {
        this.fields.put(field, reason);
    }

    public boolean isValid() {
        return this.fields.isEmpty();
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public String getReason(String fieldName) {
        return this.fields.get(fieldName);
    }

    public String toString() {
        if (this.isValid()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String field : this.fields.keySet()) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            String reason = this.fields.get(field);
            buffer.append(String.format(FORMAT, field, reason));
        }
        return buffer.toString();
    }

    public void add(ValidationResult e) {
        if (this.fields == null) {
            throw new RuntimeException("You can not modify the ReadOnly VALID Result");
        }
        this.fields.putAll(e.fields);
    }
}

