package net.sf.javaprinciples.data.transformer;

/**
 * An Exception thrown by ModelElementMappers to indicate an attribute was not found.
 * 
 * @author Kay Chevalier
 * 
 */
public class AttributeNotFoundException extends RuntimeException
{

    /**
     * Constructs a new AttributeNotFoundException.
     *
     * @param msg the message.
     */
    public AttributeNotFoundException(String msg)
    {
        super(msg);
    }

    /**
     * Constructs a new AttributeNotFoundException.
     *
     * @param msg the message.
     * @param exception the cause.
     */
    public AttributeNotFoundException(String msg, Throwable exception)
    {
        super(msg, exception);
    }

}
