package net.sf.jcc.model.parser;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Child Application Context Helper. 
 * 
 * When defining a context as a bean there is no way to inject the current context
 * as the parent context.
 * This bean uses ApplicationContextAware to be notified and then sets the parent context.
 * 
 * @author wslade
 * 
 */
public class ChildApplicationContext extends ClassPathXmlApplicationContext implements ApplicationContextAware
{
    /**
     * Default Constructor.
     */
    public ChildApplicationContext()
    {
    }
    
    /**
     * Constructor for locations.
     * @param location Location of context files.
     */
    public ChildApplicationContext(String[] location)
    {
        // Set the refresh to false.
        super(location, false);
    }
    
    /**
     * Take the supplied context and set as the parent.
     * @param applicationContext the current context
     * @throws BeansException Not by us. 
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException
    {
        setParent(applicationContext);
        // refresh();
    }
}
