package net.sf.jcc.model.parser;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;

/**
 * Help the service locator have an injected bean factory.
 * 
 * Without this workaround the bean factory will be overridden by the
 * parent or current factory.
 * 
 *   <bean id="reportAdapterFactory"  class="awris.product.watermarket.NestedFactory">
 *       <property name="serviceLocatorInterface" value="awris.product.watermarket.api.internal.ReportAdapterFactory"/>
 *       <property name="beanFactory">
 *           <bean class="awris.commom.spring.ChildApplicationContext">
 *               <constructor-arg value="classpath:/spring/report-adapters.xml"/>
 *           </bean>
 *       </property>
 *   </bean>
 *  
 * @author wslade
 *
 */
public class ChildFactoryBean extends ServiceLocatorFactoryBean
{
    private boolean first = true;

    /**
     * Control how the bean factory is injected.
     * 
     * @param beanFactory Only set the factory the first time.
     * @throws BeansException Not by us.
     */
    public synchronized void setBeanFactory(BeanFactory beanFactory) throws BeansException 
    {
        if (first)
        {
            super.setBeanFactory(beanFactory);
            first = false;
        }
    }
}
