package net.sf.jcc.model.parser;

/**
 * Specification for Classes that will be responsible for transforming Elements.
 *
 * @author dcharlt
 *
 */
public interface ElementHandler
{

    /**
     * Transform the given Element.
     *
     * @param parseContext The ParseContext describing the Element to be
     *            transformed.
     *
     * @throws ElementHandlerException if the element could not be handled.
     */
    public void handleElement(ParseContext parseContext)
            throws ElementHandlerException;

    /**
     * Returns the name of this handler.
     * @return The name of the handler.
     */
    String getName();
}
