package net.sf.jcc.model.parser;

/**
 * An Exception thrown by ElementHandlers to provide context on the error that
 * has occured.
 * 
 * @author dcharlt
 * 
 */
public class ElementHandlerException extends ExpectedException
{

    private static final long serialVersionUID = 1338334510040237295L;

    /**
     * Constructs a new ElementHandlerException.
     * 
     * @param msg the message.
     */
    public ElementHandlerException(String msg)
    {
        super(msg);
    }

    /**
     * Constructs a new ElementHandlerException.
     * 
     * @param msg the message.
     * @param exception the cause.
     */
    public ElementHandlerException(String msg, Throwable exception)
    {
        super(msg, exception);
    }

}
