package net.sf.jcc.model.parser;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Class that represents an elements name.
 * 
 * @author dcharlt
 * 
 */
public class ElementName
{
    private String namespace;

    private String name;

    /**
     * Construct a new ElementName.
     * 
     * @param namespace the namespace component of the ElementName
     * @param name the name component of the ElementName
     */
    public ElementName(String namespace, String name)
    {
        assert name != null;

        this.namespace = namespace;
        this.name = name;
    }

    public String getNamespace()
    {
        return namespace;
    }

    public String getName()
    {
        return name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode()
    {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(name);
        builder.append(namespace);
        return builder.toHashCode();
    }

    /**
     * {@inheritDoc}
     */    
    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
        {
            return true;
        }
        if (obj == null)
        {
            return false;
        }
        if (getClass() != obj.getClass())
        {
            return false;
        }
        ElementName other = (ElementName) obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(name, other.name);
        builder.append(namespace, other.namespace);
        return builder.isEquals();
    }
    
    /**
     * {@inheritDoc}
     */       
    @Override
    public String toString()
    {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE);
        builder.append(namespace);        
        builder.append(name);
        return builder.toString();
    }

}
