package net.sf.jcc.model.parser;

/**
 * A specification for classes that store values to be exported at the end of
 * the transformation.
 *
 * @author dcharlt
 *
 * @param <V> The type of value that the store excepts.
 */
public interface InternalStore<V>
{

    /**
     * Adds the supplied value to the store.
     *
     * @param value The value to add to the store.
     */
    public void store(V value);

    /**
     * Exports the store.
     * The expectation is that the specific implementation of this interface will
     * include the necessary mechanisms for exporting the store according to its
     * requirements.
     * @param transformationResult strategy object that handles the export.
     */
    public void export(TransformationResult transformationResult);

    /**
     * Closes this {@code InternalStore} releasing any held resources.
     */
    public void close();

}
