package net.sf.jcc.model.parser;

/**
 * A specification for classes that encapsulate an element that has been parsed
 * from a source.
 * 
 * @author dcharlt
 * 
 */
public interface ParsedElement
{

    /**
     * Get the name of the element.
     * 
     * @return Returns the elements name
     */
    public ElementName getName();

    /**
     * Get the text of the element.
     * 
     * @return Returns the elements text
     */
    public String getText();

    /**
     * Gets the text of the elements attribute.
     * 
     * @param elementName the Name of the attribute.
     * 
     * @return Returns the attributes text
     */
    public String getAttributeText(ElementName elementName);

}
