package net.sf.jcc.model.parser;


/**
 * Specification for classes that will locate ElementHandler implementations to
 * handle a parsed Element.
 * 
 * @author dcharlt
 * 
 */
public interface TransformationRegistry
{

    /**
     * Lookup the ElementHandler for the named Element.
     * 
     * @param parseContext the ParseContext to use when performing the lookup.
     * @return An Element handler that will handed the parsed Element.
     */
    public ElementHandler lookupElementHandler(ParseContext parseContext);

}
