package net.sf.jcc.model.parser;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

/**
 * Extends the ParseContext class adding in XML specific parse information.
 *
 * @author dcharlt
 *
 */
public class XMLParseContext extends ParseContext
{
    private XMLEventReader eventReader;

    /**
     * Constructs a new XMLParseContext.
     *
     * @param parent The ParseContext of the element which is the parent to this
     *            element.
     * @param event The Event for this element.
     * @param eventReader The reader from which we are reading events.
     * @param patternFactory The pattern factory that we will use to locate
     *            patterns.
     */
    public XMLParseContext(ParseContext parent, StartElement event,
            XMLEventReader eventReader)
    {
        super(parent, createParsedElement(event, eventReader));
        this.eventReader = eventReader;
    }

    public XMLEventReader getEventReader()
    {
        return eventReader;
    }

    private static XMLParsedElement createParsedElement(StartElement event,
            XMLEventReader eventReader)
    {
        try
        {
            return new XMLParsedElement(event, eventReader.peek());
        }
        catch (XMLStreamException e)
        {
            throw new UnexpectedException("Unable to create parsed element.", e);
        }
    }
}
