package net.sf.jcc.model.parser.uml2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import au.com.sparxsystems.Association;

public class ModelElement 
{
	private String guid;
	private Object element;
	private Object extension;
	private Map<QName, List<String>> references;
    private List<Association> associations;
    private String parentGuid;

	public ModelElement(String guid, Object element)
	{
		this.guid = guid;
		this.element = element;
		references = new HashMap<QName, List<String>>();
	}

	public String getGuid()
	{
		return guid;
	}

	public Object getElement()
	{
		return element;
	}

	public void addReference(QName name, String ref)
	{
		List<String> refs = references.get(name);
		if (refs == null)
		{
			refs = new ArrayList<String>();
			references.put(name, refs);
		}
		refs.add(ref);
	}

	public Iterator<QName> references()
	{
		return references.keySet().iterator();
	}

	public String getReference(QName qname)
	{
		List<String> refs = references.get(qname);
		if (refs == null || refs.isEmpty())
		{
			return null;
		}
		return refs.get(0);
	}

	public List<String> getReferences(QName qname)
	{
		return references.get(qname);
	}

	public Object getExtension()
	{
		return extension;
	}

	public void setExtension(Object extension)
	{
		this.extension = extension;
	}

    public List<Association> getAssociations()
    {
        return associations;
    }

    public void setAssociations(List<Association> associations)
    {
        this.associations = associations;
    }

    public void addAssocation(Association association)
    {
        if (associations == null)
        {
            associations = new ArrayList<Association>();
        }
        associations.add(association);
    }

    public String getParentGuid()
    {
        return parentGuid;
    }

    public void setParentGuid(String parentGuid)
    {
        this.parentGuid = parentGuid;
    }
}
