package net.sf.jcc.model.parser.uml2;

import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ParseContext;

/**
 * An implementation of the ElementHandler specification that only handles child
 * elements, no action is taken on the current element.
 *
 * @author dcharlt
 *
 */
public class NopElementHandler implements ElementHandler
{
    private String name = this.getClass().getSimpleName();

    /**
     * {@inheritDoc}
     */
    @Override
    public void handleElement(ParseContext parseContext)
    {
    }

    /** {@inheritDoc} */
    @Override
    public String getName()
    {
        return name;
    }
}
