package net.sf.jcc.model.parser.uml2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;

import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementHandlerException;
import net.sf.jcc.model.parser.InternalStore;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.UnexpectedException;
import net.sf.jcc.model.parser.XMLParsedElement;

public class PackagedElementHandler implements ElementHandler
{
	public static final String PARENT = "parent";

	@Override
	public String getName() 
	{
		return getClass().getSimpleName();
	}
	
	@Override
	public void handleElement(ParseContext parseContext)
			throws ElementHandlerException 
	{
		XMLParsedElement pElement = (XMLParsedElement)parseContext.getParsedElement();
		
		StartElement element = pElement.getElement();
		
		Attribute attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "type"));
		String type = attr.getValue();
		String[] split = type.split(":");
		if (!split[0].equals("uml"))
		{
			throw new UnexpectedException("Invalid type namespace:" + split[0]);
		}
		try 
		{
			Class<?> umlClass = (Class<?>) Class.forName("org.omg.uml." + split[1]);
			Object e = umlClass.newInstance();
			InternalStore<ModelElement> store =  (InternalStore<ModelElement>) parseContext.getInternalStore();
			
			attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "id"));
			String guid = attr.getValue();
			
			assignProperties(e, element);

			ModelElement modelElement = new ModelElement(guid, e);
			store.store(modelElement);
			parseContext.addVariable(PARENT, modelElement);
			
			relateToParent(element, parseContext, e);
            relateParentToElement(parseContext, modelElement);
		} 
		catch (ClassNotFoundException e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private <T> void relateToParent(StartElement element,
			ParseContext parseContext, T e) 
	{
		String elementName = element.getName().getLocalPart();
		
		ParseContext parentContext = parseContext.getParent();
		if (parentContext == null)
		{
			return;
		}
		ModelElement modelElement = (ModelElement)parentContext.getLocalVariable(PARENT);
		if (modelElement == null)
		{
			return;
		}
		
		Object parent = modelElement.getElement();

		BeanWrapper wrapper = new BeanWrapperImpl(parent);
		try
		{
			Class<?> attributeClass = BeanUtils.findPropertyType(elementName, new Class[] { parent.getClass() });

			if (Collection.class.isAssignableFrom(attributeClass))
			{
				Collection<T> collection = (Collection<T>)wrapper.getPropertyValue(elementName);
				collection.add(e);
			}
			else
			{
				wrapper.setPropertyValue(elementName, e);
			}
		}
		catch (Exception ex)
		{
			
		}
	}

	private static String[] ignore = {"id", "type", "supplier"};
	
	private void assignProperties(Object e, StartElement element) 
	{
		BeanWrapper wrapper = new BeanWrapperImpl(e);
		
		for (Iterator<Attribute> itr = element.getAttributes(); itr.hasNext();)
		{
			Attribute attribute = itr.next();
			String name = attribute.getName().getLocalPart();
			if (ArrayUtils.contains(ignore, name))
			{
				continue;
			}
			
			Object value =  attribute.getValue();
			
			Class<?> attributeClass = BeanUtils.findPropertyType(name, new Class[] { e.getClass() });
			if (attributeClass.isEnum())
			{
				Method method = BeanUtils.findDeclaredMethodWithMinimalParameters(attributeClass, "fromValue");
				try {
					value = method.invoke(null, value);
				} catch (IllegalArgumentException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (IllegalAccessException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (InvocationTargetException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
			
			if (Collection.class.isAssignableFrom(attributeClass))
			{
                @SuppressWarnings("unchecked")
				Collection<Object> collection = (Collection<Object>)wrapper.getPropertyValue(name);
                collection.add(value);
			}
			else
			{
                try
                {
                    wrapper.setPropertyValue(name, value);
                }
                catch (NotWritablePropertyException e1)
                {
                }
			}
		}
	}

    private void relateParentToElement(ParseContext parseContext, ModelElement modelElement)
    {
        if (parseContext.getParent() == null)
            return;

        XMLParsedElement parentParsedElement = (XMLParsedElement)parseContext.getParent().getParsedElement();
        Attribute parentAttribute = parentParsedElement.getElement().getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "id"));
        modelElement.setParentGuid(parentAttribute == null ? null : parentAttribute.getValue());
    }

}
