package net.sf.jcc.model.parser.uml2;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import net.sf.jcc.model.parser.XmlParser;

public class StoreFactory 
{
    private XmlParser xmlParser;
    
	public void setXmlParser(XmlParser xmlParser) 
	{
		this.xmlParser = xmlParser;
	}

	public ElementStore createStore(String modelFilename)
	{
    	StoreTransformationResult transformResult = new StoreTransformationResult();
    	
    	InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(modelFilename);
    	Map<String, Object> initialProperties = new HashMap<String, Object>();
    	xmlParser.parse(ins, initialProperties, transformResult);
    	return transformResult.getElementStore();
	}
}
