package net.sf.jcc.model.parser.uml2;

import java.util.Map;

import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementName;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.TransformationRegistry;


/**
 * An implementation of the PatternRegistry specification that uses a UML model
 * registry to build ElementHandlers.
 * 
 * @author dcharlt
 * 
 */
public class TransformationRegistryImpl implements TransformationRegistry
{
	private Map<String, ElementHandler> handlers;
	private Map<String, String> namespaces;
	
    public void setHandlers(Map<String, ElementHandler> handlers) 
    {
		this.handlers = handlers;
	}

	public void setNamespaces(Map<String, String> namespaces) 
	{
		this.namespaces = namespaces;
	}

	/**
     * Constructs a new PatternRegistryImpl.
     * 
     * @param modelRegistry the ModelRegistry backing this PatternRegistry.
     * @param documentBufferName the name of CentralBufferNode defined for the
     *            document we are processing.
     */
    public TransformationRegistryImpl()
    {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ElementHandler lookupElementHandler(ParseContext parseContext)
    {
    	ElementName elementName = parseContext.getParsedElement().getName();
    	String namespace = namespaces.get(elementName.getNamespace());
    	if (namespace == null)
    	{
    		namespace = elementName.getNamespace();
    	}
    	String name = namespace + ":" + elementName.getName();
    	return handlers.get(name);
    }

}