/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.persistence.db.jdbc;

import java.util.List;
import net.sf.javaprinciples.persistence.db.jdbc.support.support.EnhancedBeanPropertySqlParameterSource;
import net.sf.javaprinciples.persistence.db.jdbc.support.support.NamedQueryProvider;
import net.sf.javaprinciples.persistence.db.jdbc.support.support.SqlParameterSourceFactory;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public abstract class DaoSupport {
    protected NamedParameterJdbcOperations jdbcTemplate;
    protected NamedQueryProvider queryProvider;
    protected SqlParameterSourceFactory sqlParameterSourceFactory;
    private String primaryKeyColumnName = "row_id";

    protected DaoSupport(NamedParameterJdbcOperations jdbcTemplate, NamedQueryProvider queryProvider, SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.jdbcTemplate = jdbcTemplate;
        this.queryProvider = queryProvider;
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    protected void logException(String method, DataAccessException ex) {
        String cause = "";
        if (ex.getCause() != null) {
            cause = " - Cause: " + ex.getCause().getMessage();
        }
        String className = this.getClass().getName();
        LoggerFactory.getLogger((String)className).error("{} operation: {} {}{}", new Object[]{className, method, ex.getMessage(), cause});
    }

    protected long performInsert(SqlParameterSource parameterSource, Enum<?> operation) {
        try {
            String query = this.queryProvider.getQuery(operation.name());
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(query, parameterSource, (KeyHolder)generatedKeyHolder, new String[]{this.primaryKeyColumnName});
            return generatedKeyHolder.getKey().longValue();
        }
        catch (DataAccessException e) {
            this.logException(operation.name(), e);
            throw e;
        }
    }

    protected <T> List<T> performQuery(SqlParameterSource parameterSource, Enum<?> operation, ParameterizedRowMapper<T> rowMapper) {
        try {
            String query = this.queryProvider.getQuery(operation.name());
            return this.jdbcTemplate.query(query, parameterSource, rowMapper);
        }
        catch (DataAccessException e) {
            this.logException(operation.name(), e);
            throw e;
        }
    }

    protected <T> T performQueryForZeroToSingleResult(SqlParameterSource parameterSource, Enum<?> operation, ParameterizedRowMapper<T> rowMapper) {
        try {
            String query = this.queryProvider.getQuery(operation.name());
            return (T)this.jdbcTemplate.queryForObject(query, parameterSource, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (DataAccessException e) {
            this.logException(operation.name(), e);
            throw e;
        }
    }

    protected <T> T performQueryForSingleResult(SqlParameterSource parameterSource, Enum<?> operation, ParameterizedRowMapper<T> rowMapper) {
        try {
            String query = this.queryProvider.getQuery(operation.name());
            return (T)this.jdbcTemplate.queryForObject(query, parameterSource, rowMapper);
        }
        catch (DataAccessException e) {
            this.logException(operation.name(), e);
            throw e;
        }
    }

    protected int performQueryForIntResult(SqlParameterSource parameterSource, Enum<?> operation) {
        try {
            String query = this.queryProvider.getQuery(operation.name());
            return this.jdbcTemplate.queryForInt(query, parameterSource);
        }
        catch (DataAccessException e) {
            this.logException(operation.name(), e);
            throw e;
        }
    }

    protected EnhancedBeanPropertySqlParameterSource getParameterSource() {
        return (EnhancedBeanPropertySqlParameterSource)this.sqlParameterSourceFactory.getSqlParameterSource();
    }

    protected EnhancedBeanPropertySqlParameterSource getParameterSource(Object sourceBean) {
        EnhancedBeanPropertySqlParameterSource parameterSource = this.getParameterSource();
        parameterSource.setBeanParameterSource(sourceBean);
        return parameterSource;
    }

    public void setPrimaryKeyColumnName(String primaryKeyColumnName) {
        this.primaryKeyColumnName = primaryKeyColumnName;
    }
}

