/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.persistence.db.jdbc.support.support;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class ConversionServiceAwareBeanPropertyRowMapper<T>
extends ParameterizedBeanPropertyRowMapper<T> {
    private ConversionService conversionService;
    private Map<Class<?>, BeanWrapper> beanWrapperCache;

    public ConversionServiceAwareBeanPropertyRowMapper(Class<T> mappedClass, ConversionService conversionService) {
        this.conversionService = conversionService;
        this.beanWrapperCache = new ConcurrentHashMap();
        this.setMappedClass(mappedClass);
    }

    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        Object rootObject = super.mapRow(rs, rowNumber);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)rootObject);
        bw.setAutoGrowNestedPaths(true);
        this.initBeanWrapper(bw);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
            if (!this.isSubPropertyExpression(bw, column)) continue;
            this.setSubPropertyValue(rs, bw, index, column);
        }
        return (T)rootObject;
    }

    private void setSubPropertyValue(ResultSet rs, BeanWrapper bw, int index, String column) throws SQLException {
        String propertyPath = this.makeSanePropertyPath(bw, column.toLowerCase());
        PropertyDescriptor pd = bw.getPropertyDescriptor(propertyPath);
        try {
            Object value = this.getColumnValue(rs, index, pd);
            try {
                bw.setPropertyValue(propertyPath, value);
            }
            catch (TypeMismatchException e) {
                if (value != null) {
                    throw e;
                }
            }
        }
        catch (NotWritablePropertyException ex) {
            throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + pd.getName(), (Throwable)ex);
        }
    }

    private boolean isSubPropertyExpression(BeanWrapper bw, String column) {
        int idx = column.indexOf(95);
        if (idx < 1 || idx == column.length() - 1) {
            return false;
        }
        String propertyName = this.makeSaneProperty(bw, column.substring(0, idx).toLowerCase());
        return bw.isWritableProperty(propertyName);
    }

    private String makeSanePropertyPath(BeanWrapper bw, String propertyPath) {
        String[] pathComponents;
        StringBuffer sanePath = new StringBuffer();
        boolean first = true;
        BeanWrapper currentBeanWrapper = bw;
        int componentIdx = 0;
        for (String pathComponent : pathComponents = propertyPath.split("_")) {
            String saneComponent = this.makeSaneProperty(currentBeanWrapper, pathComponent);
            if (componentIdx < pathComponents.length - 1) {
                currentBeanWrapper = this.getBeanWrapper(currentBeanWrapper, saneComponent);
            }
            if (!first) {
                sanePath.append(".");
            }
            sanePath.append(saneComponent);
            first = false;
            ++componentIdx;
        }
        return sanePath.toString();
    }

    private BeanWrapper getBeanWrapper(BeanWrapper currentBeanWrapper, String saneComponent) {
        Class componentType = currentBeanWrapper.getPropertyType(saneComponent);
        if (!this.beanWrapperCache.containsKey(componentType)) {
            this.beanWrapperCache.put(componentType, (BeanWrapper)new BeanWrapperImpl(componentType));
        }
        return this.beanWrapperCache.get(componentType);
    }

    private String makeSaneProperty(BeanWrapper bw, String propertyName) {
        for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
            if (!pd.getName().toLowerCase().equals(propertyName)) continue;
            return pd.getName();
        }
        return propertyName;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        bw.setConversionService(this.conversionService);
    }
}

