/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.persistence.db.jdbc.support.support;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.LobHandler;

public class EnhancedBeanPropertySqlParameterSource
extends AbstractSqlParameterSource {
    private SqlParameterSource beanPropertySource;
    private MapSqlParameterSource additionalParameters = new MapSqlParameterSource();
    private Map<String, Integer> parameterToSqlType = new HashMap<String, Integer>();
    private ConversionService conversionService;
    private LobHandler lobHandler;

    public EnhancedBeanPropertySqlParameterSource(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setBeanParameterSource(Object bean) {
        this.beanPropertySource = new BeanPropertySqlParameterSource(bean);
    }

    public void addParameter(String paramName, Object paramVal) {
        this.additionalParameters.addValue(paramName, paramVal);
    }

    public void setSqlTypeForParameter(String paramName, int sqlType) {
        this.parameterToSqlType.put(paramName, sqlType);
    }

    public boolean hasValue(String paramName) {
        if (this.additionalParameters.hasValue(paramName)) {
            return true;
        }
        return this.beanHasValue(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        if (this.additionalParameters.hasValue(paramName)) {
            return this.convertIfNecessary(paramName, this.additionalParameters.getValue(paramName));
        }
        return this.convertIfNecessary(paramName, this.beanValue(paramName));
    }

    private boolean beanHasValue(String paramName) {
        if (this.beanPropertySource != null) {
            return this.beanPropertySource.hasValue(paramName);
        }
        return false;
    }

    private Object beanValue(String paramName) {
        if (this.beanPropertySource != null) {
            return this.beanPropertySource.getValue(paramName);
        }
        return null;
    }

    private Object convertIfNecessary(String paramName, Object beanValue) {
        if (beanValue == null) {
            return beanValue;
        }
        Object converted = beanValue;
        if (this.conversionService != null && this.conversionService.canConvert(beanValue.getClass(), String.class)) {
            converted = this.conversionService.convert(beanValue, String.class);
        }
        if (converted instanceof Enum) {
            return converted.toString();
        }
        if (this.getSqlType(paramName) == 2005) {
            return new SqlLobValue(converted.toString(), this.lobHandler);
        }
        return converted;
    }

    public int getSqlType(String paramName) {
        if (this.parameterToSqlType.containsKey(paramName)) {
            return this.parameterToSqlType.get(paramName);
        }
        if (this.additionalParameters.hasValue(paramName)) {
            return this.additionalParameters.getSqlType(paramName);
        }
        if (this.beanPropertySource != null) {
            return this.beanPropertySource.getSqlType(paramName);
        }
        return Integer.MIN_VALUE;
    }
}

