/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.state;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;
import net.sf.jcc.state.EffectEngine;
import net.sf.jcc.state.GuardMatch;
import net.sf.jcc.state.StateEngine;
import org.omg.uml.Behavior;
import org.omg.uml.Constraint;
import org.omg.uml.NamedElement;
import org.omg.uml.OpaqueBehavior;
import org.omg.uml.OpaqueExpression;
import org.omg.uml.Pseudostate;
import org.omg.uml.PseudostateKind;
import org.omg.uml.Region;
import org.omg.uml.State;
import org.omg.uml.StateMachine;
import org.omg.uml.Transition;
import org.omg.uml.Trigger;

public class StateEngineImpl<Entity>
implements StateEngine<Entity> {
    private static final String INITIAL_STATE = ".!intial";
    private ElementStore store;
    private String stateMachineIdentifier;
    private GuardMatch<Entity> guardMatch;
    private EffectEngine<Entity> effectEngine;
    private transient Map<String, State> statesByName;

    public String initialise(Entity target, String trigger) {
        return this.signal(target, INITIAL_STATE, trigger);
    }

    public String signal(Entity target, String stateName, String trigger) {
        State state = this.getState(stateName);
        List<Transition> transitions = this.resolveTransitions(state);
        for (Transition transition : transitions) {
            if (!this.matchTransition(transition, target, trigger)) continue;
            this.raiseEffect(transition, target);
            String targetStateRef = transition.getTarget();
            ModelElement element = this.store.get(targetStateRef);
            return ((State)element.getElement()).getName();
        }
        return stateName;
    }

    protected void raiseEffect(Transition transition, Entity target) {
        if (this.effectEngine == null) {
            return;
        }
        for (Behavior behavior : transition.getEffect()) {
            List bodies = ((OpaqueBehavior)behavior).getBody();
            if (bodies.isEmpty()) {
                throw new RuntimeException("ModelValidation: Transition:" + transition.getName() + " does not have an expression.");
            }
            if (bodies.size() > 1) {
                throw new RuntimeException("ModelValidation: Transition:" + transition.getName() + " has more than one expression.");
            }
            this.effectEngine.invokeEffect(target, (String)bodies.get(0));
        }
    }

    public void setStore(ElementStore store) {
        this.store = store;
    }

    public void setGuardMatch(GuardMatch<Entity> guardMatch) {
        this.guardMatch = guardMatch;
    }

    public void setStateMachineIdentififer(String stateMachineIdentifier) {
        this.stateMachineIdentifier = stateMachineIdentifier;
    }

    public void setEffectEngine(EffectEngine<Entity> effectEngine) {
        this.effectEngine = effectEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State getState(String stateName) {
        StateEngineImpl stateEngineImpl = this;
        synchronized (stateEngineImpl) {
            if (this.statesByName == null) {
                this.loadDefinition();
            }
        }
        return this.statesByName.get(stateName);
    }

    protected void loadDefinition() {
        ModelElement stateMachineElement = this.store.get(this.stateMachineIdentifier);
        if (stateMachineElement == null) {
            throw new RuntimeException("ModelValidation: GUID not found:" + this.stateMachineIdentifier);
        }
        StateMachine stateMachine = (StateMachine)stateMachineElement.getElement();
        Region region = stateMachine.getRegion();
        this.statesByName = new HashMap<String, State>();
        for (State state : region.getSubvertex()) {
            if (state instanceof Pseudostate && ((Pseudostate)state).getKind() == PseudostateKind.INITIAL) {
                this.statesByName.put(INITIAL_STATE, state);
                continue;
            }
            this.statesByName.put(state.getName(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Transition> resolveTransitions(State state) {
        State state2 = state;
        synchronized (state2) {
            List transitions = state.getOutgoing();
            if (transitions.size() != 0) {
                return transitions;
            }
            ModelElement stateElement = this.store.reverse((Object)state);
            List refs = stateElement.getReferences(new QName("outgoing"));
            if (refs == null) {
                throw new RuntimeException("ModelValidation: State:" + state.getName() + " does not have an outgoing transition.");
            }
            for (String ref : refs) {
                ModelElement outgoing = this.store.get(ref);
                Transition transition = (Transition)outgoing.getElement();
                transitions.add(transition);
            }
            return transitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Trigger> resolveTriggers(Transition transition) {
        Transition transition2 = transition;
        synchronized (transition2) {
            List triggers = transition.getTrigger();
            if (triggers.size() != 0) {
                return triggers;
            }
            ModelElement transitionElement = this.store.reverse((Object)transition);
            List refs = transitionElement.getReferences(new QName("trigger"));
            if (refs == null) {
                return triggers;
            }
            for (String ref : refs) {
                ModelElement outgoing = this.store.get(ref);
                Trigger trigger = (Trigger)outgoing.getElement();
                triggers.add(trigger);
            }
            return triggers;
        }
    }

    protected <T extends NamedElement> T findElement(List<T> elements, String name) {
        for (NamedElement element : elements) {
            if (!element.getName().equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    protected boolean matchTransition(Transition transition, Entity target, String triggerName) {
        List<Trigger> triggers;
        Trigger trigger;
        if (triggerName != null && (trigger = this.findElement(triggers = this.resolveTriggers(transition), triggerName)) == null) {
            return false;
        }
        List guards = transition.getGuard();
        if (guards.isEmpty()) {
            return true;
        }
        for (Constraint guard : guards) {
            List bodies = ((OpaqueExpression)guard.getSpecification()).getBody();
            if (bodies.isEmpty()) {
                throw new RuntimeException("ModelValidation: Guard:" + guard.getName() + " does not have an expression.");
            }
            if (bodies.size() > 1) {
                throw new RuntimeException("ModelValidation: Guard:" + guard.getName() + " has more than one expression.");
            }
            if (!this.guardMatch.match(target, (String)bodies.get(0))) continue;
            return true;
        }
        return false;
    }
}

