/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.web;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.javaprinciples.core.RequestContext;
import net.sf.javaprinciples.core.UnexpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServletRequestContextFilter
implements Filter {
    private static final String CORRELATION = "X-Correlation";
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOGGER = "logger";
    private FilterConfig config;
    private Logger logger;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        String loggerName = config.getInitParameter(LOGGER);
        if (!StringUtils.hasText((String)loggerName)) {
            loggerName = ServletRequestContextFilter.class.getPackage().getName();
        }
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public void destroy() {
        this.config = null;
        this.logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new UnexpectedException("This servlet only works with HTTP requests!");
        }
        this.correlateRequest((HttpServletRequest)request);
        try {
            this.logAndChainRequest((HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        finally {
            RequestContext.resetCorrelation();
            RequestContext.resetPrincipal();
        }
    }

    protected void logAndChainRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = request.getRequestURI();
        String correlation = RequestContext.getCorrelation();
        if (correlation != null) {
            response.addHeader(CORRELATION, correlation);
        }
        long before = System.currentTimeMillis();
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        long after = System.currentTimeMillis();
        long duration = after - before;
        this.logger.info("{},{},{}", new Object[]{uri, request.getMethod(), duration});
    }

    protected void correlateRequest(HttpServletRequest httpRequest) {
        String correlationId = httpRequest.getHeader(CORRELATION);
        if (!StringUtils.hasText((String)correlationId)) {
            RequestContext.putCorrelation();
        } else {
            RequestContext.putCorrelation((String)correlationId);
        }
        Principal principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            String user = httpRequest.getHeader(AUTHORIZATION);
            if (!StringUtils.hasText((String)user)) {
                user = this.config.getFilterName();
            }
            principal = new UserPrincipal(user);
        }
        RequestContext.putPrincipal((Principal)principal);
    }
}

