/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.auth;

import javax.inject.Inject;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.auth.Authenticator;
import net.sf.jstuff.integration.ldap.LdapException;
import net.sf.jstuff.integration.ldap.LdapTemplate;
import net.sf.jstuff.integration.userregistry.UserDetails;
import net.sf.jstuff.integration.userregistry.UserDetailsService;

public class LdapAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.create();
    protected LdapTemplate ldapTemplate = (LdapTemplate)NullAnalysisHelper.lazyNonNull();
    protected UserDetailsService userDetailsService = (UserDetailsService)NullAnalysisHelper.lazyNonNull();

    public LdapAuthenticator() {
        LOG.infoNew((Object)this);
    }

    @Override
    public boolean authenticate(String logonName, String password) {
        LOG.trace("Trying to authenticate user %s", (Object)logonName);
        UserDetails userDetails = this.userDetailsService.getUserDetailsByLogonName(logonName);
        if (userDetails == null) {
            LOG.trace("Authentication failed. Unkown user with loginName=%s", (Object)logonName);
            return false;
        }
        try {
            this.ldapTemplate.execute(ctx -> {
                ctx.addToEnvironment("java.naming.security.authentication", "simple");
                ctx.addToEnvironment("java.naming.security.principal", userDetails.getDistinguishedName());
                ctx.addToEnvironment("java.naming.security.credentials", password);
                return ctx.lookup(userDetails.getDistinguishedName());
            });
            return true;
        }
        catch (LdapException ex) {
            LOG.trace("Authentication failed.", (Object)ex);
            return false;
        }
    }

    @Inject
    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    @Inject
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

