/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.ArrayUtils;
import net.sf.jstuff.core.compression.AbstractCompression;
import net.sf.jstuff.core.validation.Args;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCompression
extends AbstractCompression {
    private static final int DEFAULT_BLOCK_SIZE = 65536;
    public static final SnappyCompression INSTANCE = new SnappyCompression();

    protected SnappyCompression() {
    }

    public InputStream createDecompressingInputStream(InputStream compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return new SnappyInputStream(compressed);
    }

    public OutputStream createCompressingOutputStream(OutputStream output) throws IOException {
        Args.notNull((String)"output", (Object)output);
        return new SnappyOutputStream(output, 65536);
    }

    public String toString() {
        return Strings.toString((Object)((Object)this), (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY);
    }
}

