/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.compression;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.compression.AbstractCompression;
import net.sf.jstuff.core.validation.Args;

public class ZStdCompression
extends AbstractCompression {
    public static final int LEVEL_SMALL_AS_DEFLATE_4 = 2;
    public static final int LEVEL_SMALL_AS_DEFLATE_6 = 3;
    public static final int LEVEL_SMALL_AS_DEFLATE_9 = 3;
    public static final ZStdCompression INSTANCE = new ZStdCompression(2, false);
    private final boolean useChecksum;
    private final int compressionLevel;

    public ZStdCompression(int compressionLevel) {
        this(compressionLevel, false);
    }

    public ZStdCompression(int compressionLevel, boolean useChecksum) {
        this.compressionLevel = compressionLevel;
        this.useChecksum = useChecksum;
    }

    public byte[] compress(byte[] uncompressed) throws IOException {
        Args.notNull((String)"uncompressed", (Object)uncompressed);
        long maxSize = Zstd.compressBound((long)uncompressed.length);
        if (maxSize > Integer.MAX_VALUE) {
            throw new IOException("Max output size is greater than Integer.MAX_VALUE!");
        }
        byte[] dst = new byte[(int)maxSize];
        long rc = Zstd.compress((byte[])dst, (byte[])uncompressed, (int)this.compressionLevel);
        if (Zstd.isError((long)rc)) {
            throw new IOException(Zstd.getErrorName((long)rc));
        }
        int size = (int)rc;
        byte[] out = new byte[size];
        System.arraycopy(dst, 0, out, 0, size);
        return out;
    }

    public OutputStream createCompressingOutputStream(OutputStream output) throws IOException {
        Args.notNull((String)"output", (Object)output);
        ZstdOutputStream out = new ZstdOutputStream(output, this.compressionLevel);
        out.setCloseFrameOnFlush(true);
        out.setChecksum(this.useChecksum);
        return out;
    }

    public InputStream createDecompressingInputStream(InputStream compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return new ZstdInputStream(compressed);
    }

    public int decompress(byte[] compressed, byte[] output) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        Args.notNull((String)"output", (Object)output);
        long rc = Zstd.decompress((byte[])output, (byte[])compressed);
        if (Zstd.isError((long)rc)) {
            if (rc == -70L) {
                throw new IndexOutOfBoundsException("[output] byte array of size " + output.length + " is too small for given input.");
            }
            throw new IOException(Zstd.getErrorName((long)rc));
        }
        return (int)rc;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean isUseChecksum() {
        return this.useChecksum;
    }

    public String toString() {
        return Strings.toString((Object)((Object)this), (Object[])new Object[]{"compressionLevel", this.compressionLevel});
    }
}

